﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Kalend;
using Soneta.Core;
using System.Globalization;

namespace ASP {

    public partial class Umowa_O_Pracę : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_Od = "od";
        public string Str_Do = "do";
        public string Str_Otrzymalam = "otrzymałam";
        public string Str_Otrzymalem = "otrzymałem";
        public string Str_Brutto = "brutto";

        public enum StawkaNettoBrutto {
            brutto,
            netto
        }
		    
	    public class _Info: ContextBase {
	
		    public _Info(Context context): base(context) {
                reprezentant = KadryModule.GetInstance(context).Config.Wydruki.OsobaReprezentującaPracodawcę;
                stanNaDzień = ((ActualDate)Context[typeof(ActualDate)]).Actual;
            }
		
		    string reprezentant;
		    [Soneta.Business.Required]
            [Priority(10)]
		    [Caption("Reprezent. pracodawcę")]
		    public string Reprezentant {
			    get { return reprezentant; }
			    set { 
				    reprezentant = value; 
				    OnChanged(EventArgs.Empty);
			    }
		    }

            Date stanNaDzień;
            [Priority(20)]
            [Caption("Stan na dzień")]
            public Date StanNaDzień {
                get { return stanNaDzień; }
                set {
                    stanNaDzień = value;
                    OnChanged(EventArgs.Empty);
                }
            }        
	    }
	
	    _Info info;
	    [Context]
	    public _Info Info {
		    set { info = value; }
	    }
	
        protected void dc_ContextLoad(Object sender, EventArgs e) {
            Pracownik p = (Pracownik)dc[typeof(Pracownik)];
            PracHistoria ph = p[info.StanNaDzień];

            System.Globalization.CultureInfo ci = new System.Globalization.CultureInfo(Str_CultureInfo);

            ReportHeader1["TYP"] = CaptionAttribute.EnumToString(ph.Etat.TypUmowy, ci).ToUpper();

            dlPlec1.EditValue = dlPlec2.EditValue = ph.Plec;
            dlAdres.EditValue = ph.Adres;
            dlPESEL.EditValue = ph.PESEL;
            dlNIP.EditValue = ph.NIP;

		    dlReprezentant.EditValue = info.Reprezentant;
		    labelNettoBrutto.EditValue = Str_Brutto; // info.Stawka;
		
            FromTo okres = ph.Etat.Okres;
            if (okres.To==Date.MaxValue)
                dlNaOkres.EditValue = string.Format(Str_Od + " <strong>{0}</strong>", okres.From);
            else
			    dlNaOkres.EditValue = string.Format(Str_Od + " <strong>{0}</strong> " + Str_Do + " <strong>{1}</strong>", okres.From, okres.To);
    
            if (ph.Etat.MiejscePracy!="")
                dlMiejsce.EditValue = ph.Etat.MiejscePracy;
            else
                dlMiejsce.EditValue = CoreModule.GetInstance(dc).Config.Firma.AdresSiedziby.ToString();

		    string osoba = ph.Plec == PłećOsoby.Kobieta ? Str_Otrzymalam : Str_Otrzymalem;
		
		    labelRodzajStawki.EditValue = CaptionAttribute.EnumToString(ph.Etat.Zaszeregowanie.RodzajStawki, ci).ToLower();
            if (ph.Etat.Wymiar == Fraction.One)
                DataLabel20.EditValue = "......";
            else
                DataLabel20.EditValue = "<strong>" + ph.Etat.LimitNadgodzin + "</strong>";
		
		    if (okres.From > Date.MinValue) {
			    string ss = "";
			    foreach (Dodatek d in ph.Pracownik.Dodatki) {
                    DodHistoria dh = d[info.StanNaDzień];
                    if (SprawdzDodatek(dh))
    			        ss += string.Format("&nbsp;&nbsp;&nbsp;{0}{1}<br/>", dh.Element.GetLocalizedNazwa(ci), WarunkuDodatku(dh));
			    }
			    labelDodatki.EditValue = ss;

                DataLabel7.EditValue = ph.Etat.Zaszeregowanie.Wymiar;
                DataLabel8.EditValue = ph.Etat.Zaszeregowanie.Stawka;
                DataLabel9.EditValue = ph.Etat.DataRozpPracy;
                DataLabel10.EditValue = ph.Etat.DataZawarcia;
                DataLabel11.EditValue = ph.Etat.Stanowisko;
                DataLabel12.EditValue = ph.Etat.Funkcja;
                DataLabel13.EditValue = ph.Etat.TypUmowy;
            }
        }

        bool SprawdzDodatek(DodHistoria dh) {
            if (!dh.Element.Dodatkowe.DodatekDoEtatu)
                return false;
            if (dh.Okres.From > info.StanNaDzień)
                return false;
            if (dh.Okres.To != Date.Empty && dh.Okres.To < info.StanNaDzień)
                return false;
            return true;
        }
    
        string WarunkuDodatku(DodHistoria dh) {
		    string ss = "";
		
		    if (dh.Procent!=Percent.Zero)
			    ss = DodajParametr(ss, dh.Element.Algorytm.DodProcent, dh.Procent);
			
		    if (dh.Ulamek!=Fraction.Zero)
			    ss = DodajParametr(ss, dh.Element.Algorytm.DodUlamek, dh.Ulamek);
			
		    if (dh.Wspolczynnik!=0m)
			    ss = DodajParametr(ss, dh.Element.Algorytm.DodWspolczynnik, dh.Wspolczynnik);
			
		    if (dh.Podstawa!=Currency.Zero)
			    ss = DodajParametr(ss, dh.Element.Algorytm.DodPodstawa, dh.Podstawa.ToString("u", CultureInfo.CurrentCulture));
			
		    if (dh.Czas!=Time.Zero)
			    ss = DodajParametr(ss, dh.Element.Algorytm.DodCzas, dh.Czas);
			
		    if (dh.Dni!=0)
			    ss = DodajParametr(ss, dh.Element.Algorytm.DodDni, dh.Dni);
			
		    if (ss=="")
			    return "";
		    return "&nbsp;(" + ss + ")";
        }
    
        string DodajParametr(string ss, string label, object value) {
		    if (ss!="")
			    ss += ",&nbsp;";
		    ss += string.Format("<strong>{1}</strong>", label.ToLower(), value);
		    return ss;
        }
    }
}
